/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.hollingsworth.arsnouveau.client.jei.EnchantingApparatusRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.JEIArsNouveauPlugin;
import com.hollingsworth.arsnouveau.client.jei.MultiInputCategory;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantmentRecipe;
import com.hollingsworth.arsnouveau.common.util.HolderHelper;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;

public class ApparatusEnchantingRecipeCategory
extends EnchantingApparatusRecipeCategory<EnchantmentRecipe> {
    public ApparatusEnchantingRecipeCategory(IGuiHelper helper) {
        super(helper);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, EnchantmentRecipe recipe, IFocusGroup focuses) {
        List<Ingredient> inputs = ((MultiInputCategory.MultiProvider)this.multiProvider.apply(recipe)).input();
        double angleBetweenEach = 360.0 / (double)inputs.size();
        ClientLevel level = Minecraft.getInstance().level;
        ItemStack dummy = recipe.enchantLevel > 1 ? EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(HolderHelper.unwrap((Level)level, recipe.enchantmentKey), recipe.enchantLevel - 1)) : Items.BOOK.getDefaultInstance();
        MutableComponent message = recipe.enchantLevel == 1 ? Component.literal((String)"Any compatible item") : Component.literal((String)"Needs lower level enchantment");
        dummy.set(DataComponents.CUSTOM_NAME, (Object)message);
        builder.addSlot(RecipeIngredientRole.INPUT, 48, 45).addItemStack(dummy);
        for (Ingredient input : inputs) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)this.point.x, (int)this.point.y).addIngredients(input);
            this.point = ApparatusEnchantingRecipeCategory.rotatePointAbout(this.point, this.center, angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 10).addItemStack(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(HolderHelper.unwrap((Level)level, recipe.enchantmentKey), recipe.enchantLevel)));
    }

    @Override
    public Component getTitle() {
        return Component.translatable((String)"ars_nouveau.enchanting");
    }

    @Override
    public RecipeType<EnchantmentRecipe> getRecipeType() {
        return JEIArsNouveauPlugin.ENCHANTING_RECIPE_TYPE;
    }
}

